//
//  GHCustomSettings.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 7/27/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 * Error with updating custom settings.
 */
typedef NS_ENUM(NSInteger, GHCustomSettingsError) {
    /** Unexpected error */
    GHCustomSettingsErrorUndefined = 0,
    /** Required property was out of range. */
    GHCustomSettingsErrorInvalid = 1,
};

/** Error domain for the errors generated by this class */
extern NSString * _Nonnull const GHCustomSettingsErrorDomain;


#pragma mark -
@interface GHCustomSettings : NSObject


@end
